unit AboutBox;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

// Standard re-usable about-box. Gets the program name from
// the application object's Title field, and reads version and
// copyright information from the version resource. If the
// version resource is marked "pre-release", it adds "beta"
// to the name and puts the version label in red print.
// If a bitmap resource named ABOUTME is present, it displays
// it. (This is assumed to be a 48x48 bitmap). If not it
// displays the application's icon.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, ExtCtrls, StdCtrls, Buttons;

type
  TAboutForm = class(TForm)
    lblVersion   : TLabel;
    lblCopyright : TLabel;
    btnAboutOK   : TBitBtn;
    Panel1       : TPanel;
      Image1     : TImage;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutForm: TAboutForm;

implementation
USES AllFuncs;
{$R *.DFM}
VAR
  VerStr, CopStr : String;
  PreRel         : Boolean;

procedure TAboutForm.FormCreate(Sender: TObject);
begin
  Caption := 'About ' + Application.Title;
  Image1.Picture.Bitmap.Handle := LoadBitmap(hinstance, 'AboutMe');
  IF Image1.Picture.Bitmap.Handle = 0 THEN
    begin
      Image1.Picture.Icon := Application.Icon;
      Image1.Center := True;
    end;
  IF PreRel THEN lblVersion.Font.Color := clRed;
  IF VerStr = '' THEN
    IF PreRel THEN
      lblVersion.Caption := Application.Title + ' beta'
    ELSE lblVersion.Caption := Application.Title
  ELSE
    IF PreRel THEN
      lblVersion.Caption := Format('%s - beta version %s',
        [Application.Title, VerStr])
    ELSE
      lblVersion.Caption := Format('%s - version %s',
        [Application.Title, VerStr]);
  IF CopStr = '' THEN
    lblCopyright.Caption := 'Copyright  1999 Ziff-Davis, inC.'
  ELSE lblCopyright.Caption := CopStr;
end;

initialization
  // Get version info ONCE rather than each time
  // the About box is displayed
  PreRel := IsPreRelease(Application.ExeName);
  VerStr := GetVersionString(Application.ExeName, vsFileVersion);
  CopStr := GetVersionString(Application.ExeName, vsLegalCopyright);
end.



