unit expFormu;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  ComCtrls, Forms, StdCtrls;

type
  TExpForm = class(TForm)
    Label1      : TLabel;
    lblName     : TLabel;
    Label2      : TLabel;
    lblCmd      : TLabel;
    Label3      : TLabel;
    lblState    : TLabel;
    Label4      : TLabel;
    lblAction   : TLabel;
    Label5      : TLabel;
    lblFrom     : TLabel;
    Label6      : TLabel;
    lblLocation : TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ShareMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
    statIdx,           // index for current state
    actnIdx : Integer; // index for action
    MainR   : TRect;   // main rectangle w/o shadows
    windir  : String;  // Windows folder
    bShadow,           // 40x6 bottom shadow region piece
    sShadow : hRgn;    // 6x40 side shadow region piece
    procedure WmKillFocus(VAR Msg : TWMKillFocus);
      message WM_KILLFOCUS;
  public
    { Public declarations }
    procedure CreateParams(VAR Params : TCreateParams); override;
    procedure SetItem(IT : TListItem);
  end;

var
  ExpForm: TExpForm;

implementation

uses mainu, AllFuncs, shellapi, shlobj, scopshar;

{$R *.DFM}

procedure TExpForm.FormCreate(Sender: TObject);
VAR
  R1   : hRgn;
  I, J : Integer;
begin
  // Create regions that will be used to build the bottom
  // and side shadows
  bShadow := CreateRectRgn(0, 0, 0, 0);
  sShadow := CreateRectRgn(0, 0, 0, 0);
  FOR I := 0 TO 40 DO
    FOR J := 0 TO 6 DO
      IF odd(I+J) THEN
        begin
          R1 := CreateRectRgn(I, J, I+1, J+1);
          CombineRgn(bShadow, bShadow, R1, RGN_OR);
        end
      ELSE
        begin
          R1 := CreateRectRgn(J, I, J+1, I+1);
          CombineRgn(sShadow, sShadow, R1, RGN_OR);
        end;
  // Get Windows folder with final backslash
  SetLength(windir, MAX_PATH);
  SetLength(windir, GetWindowsDirectory(PChar(windir), MAX_PATH));
  windir := FinalSlash(windir);
end;

procedure TExpForm.FormPaint(Sender: TObject);
VAR R : TRect;
begin
  // Only draw the action icon if it differs from current state
  IF actnIdx = statIdx THEN
    begin
      Canvas.Brush.Color := Color;
      Canvas.FillRect(Bounds(lblAction.Left-18,
        lblAction.Top, 16, 16));
    end
  ELSE
    MainForm.ImageList1.Draw(Canvas, lblAction.Left-18,
      lblAction.Top, actnIdx);
  // Draw the state icon
  MainForm.ImageList1.Draw(Canvas, lblState.Left-18,
    lblState.Top, statIdx);
  R := MainR;
  Dec(R.Right);
  Dec(R.Bottom);
  // Draw the outer border line
  Canvas.Pen.Color   := clBlack;
  Canvas.PolyLine([Point(R.Left, R.Top), Point(R.Right, R.Top),
    Point(R.Right, R.Bottom), Point(R.Left, R.Bottom),
    Point(R.Left, R.Top)]);
  // Draw the inner border line
  InflateRect(R, -1, -1);
  Canvas.Pen.Color   := clSilver;
  Canvas.PolyLine([Point(R.Left, R.Top), Point(R.Right, R.Top),
    Point(R.Right, R.Bottom), Point(R.Left, R.Bottom),
    Point(R.Left, R.Top)]);
  Canvas.Brush.Color := clBlack;
  // draw the bottom shadow
  R.Left   := MainR.Left   + 6;
  R.Right  := MainR.Right  + 6;
  R.Top    := MainR.Bottom;
  R.Bottom := MainR.Bottom + 6;
  Canvas.FillRect(R);
  // draw the side shadow
  R.Left   := MainR.Right;
  R.Right  := MainR.Right  + 6;
  R.Top    := MainR.Top    + 6;
  R.Bottom := MainR.Bottom + 6;
  Canvas.FillRect(R);
end;

procedure TExpForm.FormClick(Sender: TObject);
// Close if the form is clicked
begin
  Close;
end;

procedure TExpForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
// Close if a key is pressed
begin
  Close;
end;

procedure TExpForm.ShareMouseUp(Sender: TObject; Button:
  TMouseButton; Shift: TShiftState; X, Y: Integer);
// Close on any mouse click
begin
  Close;
end;

procedure TExpForm.WmKillFocus(VAR Msg : TWMKillFocus);
// Close if the window loses focus
begin
  Close;
end;

procedure TExpForm.CreateParams(VAR Params : TCreateParams);
// Create as a simple popup window, no border
begin
  Inherited CreateParams(Params);
  WITH Params DO Style := WS_POPUP;
end;

procedure TExpForm.SetItem(IT : TListItem);
// Initialize the display fields of the window from the
// information in the passed TListitem
VAR
  P     : TPoint;
  Where : String;
  R, R1 : hRgn;
  Wrk   : TRect;
  X     : Integer;

  function WidestLabel : Integer;
  begin
    Result := lblName.Width;
    IF lblFrom.Width > Result THEN Result := lblFrom.Width;
    IF lblCmd.Width > Result THEN Result := lblCmd.Width;
    IF lblLocation.Width > Result THEN Result := lblLocation.Width;
  end;

begin
  actnIdx := IT.StateIndex;
  statIdx := Integer(IT.Data);
  CASE statIdx OF
    1 : lblState.Caption := 'Enabled';
    2 : lblState.Caption := 'Disabled';
    3 : lblState.Caption := 'Packed for removal';
    4 : lblState.Caption := 'Ready for removal';
    5 : ; // cannot happen
  end;
  IF statIdx = actnIdx THEN
    lblAction.Caption := '(none)'
  ELSE
    CASE actnIdx OF
      1 : lblAction.Caption := 'To be enabled';
      2 : lblAction.Caption := 'To be disabled';
      3 : lblAction.Caption := 'To be packed for removal';
      4 : ; // cannot happen
      5 : lblAction.Caption := 'To be removed permanently';
    END;
  P     := Point(IT.Left, IT.Top);
  Windows.ClientToScreen(IT.ListView.Handle, P);
  Left  := P.X;
  Top   := P.Y + 16;
  MainR := Rect(0, 0, Width-6, Height-6);
  lblName.Caption := IT.Caption;
  Canvas.Font     := Self.Font;
  WrapLabel(IT.SubItems[3], 320, 64, 8, Canvas, lblCmd);
  Label3.Top      := lblCmd.Top + lblCmd.Height;
  Label4.Top      := Label3.Top + Label3.Height;
  Label5.Top      := Label4.Top + Label4.Height;
  Label6.Top      := Label5.Top + Label5.Height;
  lblState.Top    := Label3.Top;
  lblAction.Top   := Label4.Top;
  lblFrom.Top     := Label5.Top;
  lblLocation.Top := Label6.Top;
  lblFrom.Caption := names[TStSrcType(IT.ImageIndex)];
  case TStSrcType(IT.ImageIndex) OF
    sRMacS : begin
      CASE Integer(IT.Data) OF
        1 :  Where := 'HKEY_LOCAL_MACHINE\'+KeySvc;
        2 :  Where := 'HKEY_LOCAL_MACHINE\'+NotSvc;
        ELSE Where := 'HKEY_LOCAL_MACHINE\'+RemSvc;
      END;
    end;
    sILoad : begin
      CASE Integer(IT.Data) OF
        1 :  Where := windir+'WIN.INI (load= line)';
        2 :  Where := windir+'WIN.INI (noload= line)';
        ELSE Where := windir+'WIN.INI (remload= line)';
      END;
    end;
    sI_Run : begin
      CASE Integer(IT.Data) OF
        1 :  Where := windir+'WIN.INI (run= line)';
        2 :  Where := windir+'WIN.INI (norun= line)';
        ELSE Where := windir+'WIN.INI (remrun= line)';
      END;
    end;
    sRMacR : begin
      CASE Integer(IT.Data) OF
        1 :  Where := 'HKEY_LOCAL_MACHINE\'+KeyRun;
        2 :  Where := 'HKEY_LOCAL_MACHINE\'+NotRun;
        ELSE Where := 'HKEY_LOCAL_MACHINE\'+RemRun;
      END;
    end;
    sRPerR : begin
      CASE Integer(IT.Data) OF
        1 :  Where := 'HKEY_CURRENT_USER\'+KeyRun;
        2 :  Where := 'HKEY_CURRENT_USER\'+NotRun;
        ELSE Where := 'HKEY_CURRENT_USER\'+RemRun;
      END;
    end;
    sCommn : begin
      Where := GetSpecialPath(Handle, CSIDL_COMMON_STARTUP);
      CASE Integer(IT.Data) OF
        1 : ; // no change
        2 :  Where := FinalSlash(ExtractFileDir(Where)) + DisStart;
        ELSE Where := FinalSlash(ExtractFileDir(Where)) + RemStart;
      END;
    end;
    sStart : begin
      Where := GetSpecialPath(Handle, CSIDL_STARTUP);
      CASE Integer(IT.Data) OF
        1 : ; // no change
        2 :  Where := FinalSlash(ExtractFileDir(Where)) + DisStart;
        ELSE Where := FinalSlash(ExtractFileDir(Where)) + RemStart;
      END;
    end;
  end;
  WrapLabel(Where, 320, 64, 8, Canvas, lblLocation);
  // Now adjust the window size
  Width  := lblName.Left + WidestLabel + 16;
  Height := lblLocation.Top + lblLocation.Height + 10;
  // If it's too far down, put it above the item
  SystemParametersInfo(SPI_GETWORKAREA, 0, @Wrk, 0);
  IF Top + Height > Wrk.Bottom THEN
    Top := Top - Height - 18;
  // If out of the viewable area to left or right, move it back in
  IF Left < 4 THEN Left := 4;
  IF Left+Width > Wrk.Right - 4 THEN
    Left := Wrk.Right - Width - 4;
  // Sum of width and height must be odd else shadows won't mesh
  IF NOT Odd(Width+Height) THEN Width := Width + 1;
  MainR  := Rect(0, 0, Width-6, Height-6);
  R      := CreateRectRgn(0, 0, Width-6, Height-6);
  R1     := CreateRectRgn(0, 0, 0, 0);
  CombineRgn(R1, bShadow, bShadow, RGN_COPY);
  OffsetRgn(R1,  6, Height-6);
  X := 6;
  REPEAT
    CombineRgn(R, R, R1, RGN_OR);
    OffsetRgn(R1, 40, 0);
    Inc(X, 40);
  UNTIL X > Width;
  CombineRgn(R1, sShadow, sShadow, RGN_COPY);
  OffsetRgn(R1, Width-6, 6);
  X := 6;
  REPEAT
    CombineRgn(R, R, R1, RGN_OR);
    OffsetRgn(R1, 0, 40);
    Inc(X, 40);
  UNTIL X > Height;
  SetWindowRgn(Handle, R, False);
end;

procedure TExpForm.FormHide(Sender: TObject);
begin
  MainForm.lvProgs.SetFocus;
end;

end.
