program startcop;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

uses
  Forms,
  Windows,
  SysUtils,
  mainu in 'mainu.pas' {MainForm},
  AboutBox in 'Aboutbox.pas' {AboutForm},
  expFormu in 'expFormu.pas' {ExpForm},
  scopshar in 'scopshar.pas',
  allfuncs in '..\AllFuncs.pas';

{$R *.RES}

  procedure CheckCommandLine;
  // First command-line argument must be the name of a profile.
  // If the name contains a space, it must be in quotes.
  // Optional second argument must be /L or /R (lowercase OK).
  // Anything else is an error.
  begin
    PSharedData^.CmdLine := ParamStr(1);
    IF ParamCount > 2 THEN
      PSharedData^.CmdMode := tcmError
    ELSE IF ParamStr(2) <> '' THEN
      begin
        IF AnsiCompareText(ParamStr(2), '/L') = 0 THEN
          PSharedData^.CmdMode := tcmLogoff
        ELSE IF AnsiCompareText(ParamStr(2), '/R') = 0 THEN
          PSharedData^.CmdMode := tcmRestart
        ELSE PSharedData^.CmdMode := tcmError;
      end;
  end;

VAR hMap : THandle;

begin
  // CmdLineMsg is declared in mainu.pas
  CmdLineMsg := RegisterWindowMessage(MainMsgName);
  hMap := OpenFileMapping(FILE_MAP_ALL_ACCESS, False, MainMapName);
  IF hMap = 0 THEN // first instance
    begin
      hMap := CreateFileMapping($FFFFFFFF, NIL, PAGE_READWRITE, 0,
        2*SizeOf(Integer), MainMapName);
      // PSharedData is declared in mainu.pas
      PSharedData := MapViewOfFile(hMap, FILE_MAP_ALL_ACCESS,0,0,0);
      PSharedData^.CmdMode := tcmClose;
      CheckCommandLine;
      Application.Initialize;
      Application.Title := 'Startup Cop';
      Application.CreateForm(TMainForm, MainForm);
  Application.CreateForm(TExpForm, ExpForm);
  MainForm.HandleNeeded;
      PSharedData^.AppHandle := Application.Handle;
      PSharedData^.WinHandle := MainForm.Handle;
      Application.Run;
    end
  ELSE
    begin
      PSharedData := MapViewOfFile(hMap, FILE_MAP_ALL_ACCESS,0,0,0);
      PSharedData^.CmdMode := tcmNone;
      CheckCommandLine;
      SendMessage(PSharedData^.WinHandle, CmdLineMsg, 0, 0);
    end;
  UnMapViewOfFile(PSharedData);
  CloseHandle(hMap);
end.

